#version 330
#extension GL_EXT_gpu_shader4 : enable
// sliceMod01.fsh  by   lennyjpg

//https://www.shadertoy.com/view/3ll3RS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 rotate(vec2 v, float a) {
    float s = sin(a);
    float c = cos(a);
    mat2 m = mat2(c, -s, s, c);
    return m * v;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy / iResolution.xy - 0.5;
    uv.x*= iResolution.x / iResolution.y;
    float t = iTime;
    float z = t;
    uv = rotate(uv,z*0.1);

   float st = .1;
   vec2 fu = mod(gl_FragCoord.xy,100.0);
   float grid = step(length(fu-50.0),2.0);   
    
   
    
   vec2 p = vec2(cos(uv.y*12.11),sin(uv.x*11.4))*0.21;
   float k = length(uv - p);
   k -= t*0.07;

    float g = fract(k*7.34);
    vec3 col = vec3(1.2-g);
    col.gb -= step(mod(k,1.2),0.3);
    col.rg *= step(mod(k,1.),0.8);
    gl_FragColor =  vec4(col + grid*0.5,1.0);
}